﻿var dvbIdArray = ["patTimeout", "pmtTimeout", "catTimeout", "sdtcTimeout", "sdtoTimeout", "nitcTimeout", "nitoTimeout",  "batTimeout"];
var DVB_NUM = 8;
var dvbDefaultValue = [2000, 4000, 4000, 4000, 6000, 4000, 6000, 6000];
var atscIdArray = ["patTimeout", "pmtTimeout", "catTimeout", "vctTimeout", "mgtTimeout", "sttTimeout"];
var ATSC_NUM = 6;

var atscDefaultValue = [100, 400, 0, 350, 150, 0];

var SDTA = 3;
var VCT = 8;
var ROW_NUM_ALL = 11;

var objIdArray = [dvbIdArray, atscIdArray];
var ROW_NUM = [DVB_NUM, ATSC_NUM];
var defaultValue = [dvbDefaultValue, atscDefaultValue];

var id;
var identifyData;
var DVB = 0;
var ATSC = 1;
var udpPos;

$(document).ready(function()
{
	var group;
	var userName;
	var mainIpAddr;
	var args = GetArgs();
	id = args["nodeId"];
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{	 
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	DisableButton("defaultBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	EnableButton("refreshBtn");
	EnableButton("defaultBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var response;
	var length;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formIPQAM?type=" + PSI_TIMEOUT + "&cmd=" + GET + "&id=" + id + "&language=" + language + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				length = data.length;
				identifyData = parseInt(data[length - 1], 10);
				if(identifyData == DVB)
				{
					for(var i = SDTA; i < VCT; i++)
					{
						$("#intervalTable").find("tr").eq(i).css("display", "");
					}
					for(var i = VCT; i < ROW_NUM_ALL; i++)
					{
						$("#intervalTable").find("tr").eq(i).css("display", "none");
					}
				}
				else
				{
					for(var i = SDTA; i < VCT; i++)
					{
						$("#intervalTable").find("tr").eq(i).css("display", "none");
					}
					for(var i = VCT; i < ROW_NUM_ALL; i++)
					{
						$("#intervalTable").find("tr").eq(i).css("display", "");
					}
				}
				for(var i = 0; i < ROW_NUM[identifyData]; i++)
				{
					$("#" + objIdArray[identifyData][i]).val(data[i]);
				}
			    refreshFlag = true;
			}			
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PSI_TIMEOUT + "&cmd=" + SET + "&id=" + id + "&language=" + language + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formIPQAM", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
				if(language == ENGLISH)
				{
					alert("Set Successfully!");
				}
				else
				{
					alert("设置成功！");
				}
			}
			else
			{
				alert(returnError[language][response]);
			}
			//GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	for(var i = 0; i < ROW_NUM[identifyData]; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[identifyData][i]).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[identifyData][i]).val();
		}
	}
	return data;
}

function paramCheck()
{
 	var returnFlag;

	returnFlag = ValidateParam($("#" + objIdArray[identifyData][0]), "INT_DEC", 0, 50000, "<PAT Timeout>", "<PAT搜表超时时间>", language);
	if(returnFlag == false)
	{
		return false;
	}		

	returnFlag = ValidateParam($("#" + objIdArray[identifyData][1]), "INT_DEC", 0, 50000, "<PMT Timeout>", "<PMT搜表超时时间>", language);
	if(returnFlag == false)
	{
		return false;
	}		

	returnFlag = ValidateParam($("#" + objIdArray[identifyData][2]), "INT_DEC", 0, 50000, "<CAT Timeout>", "<CAT搜表超时时间>", language);
	if(returnFlag == false)
	{
		return false;
	}		
	if(identifyData == DVB)
	{
		returnFlag = ValidateParam($("#" + objIdArray[identifyData][3]), "INT_DEC", 0, 50000, "<NIT(Actual) Timeout>", "<NIT(当前)搜表超时>", language);
		if(returnFlag == false)
		{
			return false;
		}	
		returnFlag = ValidateParam($("#" + objIdArray[identifyData][4]), "INT_DEC", 0, 50000, "<NIT(others) Timeout>", "<NIT(其他)搜表超时>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + objIdArray[identifyData][5]), "INT_DEC", 0, 50000, "<SDT(Actual) Timeout>", "<SDT(当前)搜表超时>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + objIdArray[identifyData][6]), "INT_DEC", 0, 50000, "<SDT(others) Timeout>", "<SDT(其他)搜表超时>", language);
		if(returnFlag == false)
		{
			return false;
		}		
		returnFlag = ValidateParam($("#" + objIdArray[identifyData][7]), "INT_DEC", 0, 50000, "<BAT Timeout>", "<BAT搜表超时>", language);
		if(returnFlag == false)
		{
			return false;
		}		
	}
	else
	{
		returnFlag = ValidateParam($("#" + objIdArray[identifyData][3]), "INT_DEC", 0, 50000, "<VCT Timeout>", "<VCT搜表超时>", language);
		if(returnFlag == false)
		{
			return false;
		}
		returnFlag = ValidateParam($("#" + objIdArray[identifyData][4]), "INT_DEC", 0, 50000, "<MGT Timeout>", "<MGT搜表超时>", language);
		if(returnFlag == false)
		{
			return false;
		}		
		returnFlag = ValidateParam($("#" + objIdArray[identifyData][5]), "INT_DEC", 0, 50000, "<STT Timeout>", "<STT搜表超时>", language);
		if(returnFlag == false)
		{
			return false;
		}		
	}
	return true;
}

function resetTimeout()
{
	var i;
	for(i = 0; i < ROW_NUM[identifyData]; i++)
	{
		$("#" + objIdArray[identifyData][i]).val(defaultValue[identifyData][i]);
	}
	EnableButton("applyBtn");
}